%define module_version 0.06
%define module_name Stacktrace-Configurable
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(Log/Log4perl.pm) perl(Log/Log4perl/Appender/String.pm) perl(Log/Log4perl/Layout/PatternLayout.pm) perl(Log/Log4perl/Level.pm) perl(Module/Build/Tiny.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(overload.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: a configurable Perl stack trace
Group: Development/Perl
License: perl
URL: https://github.com/tfoertsch/Stacktrace-Configurable

Source0: http://cpan.org.ua/authors/id/O/OP/OPI/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
The idea for `Stacktrace::Configurable' came when I needed a easily readable
stack trace in the Log::Log4perl manpage output. That distribution's pattern layout
can give you a stack trace but it's not very readable. There are other
modules out there that provide a caller stack, like the Devel::StackTrace manpage
and the Carp manpage. Choose what suits you best.

A stack trace is basically a list of stack frames starting with the place
where the get_trace method is called down to the main
program. The first element in that list is also called the topmost frame.

Each frame of the list collected by get_trace is a
the Stacktrace::Configurable::Frame manpage object which provides simple
accessors for the information returned by `caller'. Additionally,
a frame has a the nr entry in the Stacktrace::Configurable::Frame manpage attribute which
contains its position in the list starting from `1' (topmost).


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/S*
%perl_vendor_privlib/L*

%changelog
