%define module_name Starch-Plugin-SecureStateID
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(Math/Random/Secure.pm) perl(Moo/Role.pm) perl(MooX/MethodProxyArgs.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(Starch.pm) perl(Starch/Plugin/ForManager.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Starch.pm) perl(Types/Standard.pm) perl(namespace/clean.pm) perl(strictures.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: use cryptographically secure random when making state IDs
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HA/HANENKAMP/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
For each state stored in Starch, the generated ID is virtually guaranteed to be unique. It is not generated to be unguessable. By using this plugin, the state will include a random number generated using the Math::Random::Secure manpage to assure that is both unique and includes a cryptographically secure random number in the calculated ID.

This plugin also upgrades the state ID so that it is calculated using SHA-256 instead of SHA-1. SHA-1 hashed values are potentially guessable for attackers with a large enough budget. A possible downside is that SHA-256 creates a key that is 256 bits long, which results in an ID string that is 64 bytes long, rather than the 40 byte long string provided by SHA-1. The version of SHA used may be chosen with the the secure_state_id_sha entry elsewhere in this document option.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/S*

%changelog
