%define module_name Statistics-ANOVA
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Algorithm/Combinatorics.pm) perl(Array/Compare.pm) perl(List/AllUtils.pm) perl(Math/Cephes.pm) perl(Module/Build.pm) perl(Readonly.pm) perl(Scalar/Util.pm) perl(Statistics/ANOVA/Friedman.pm) perl(Statistics/ANOVA/JT.pm) perl(Statistics/ANOVA/KW.pm) perl(Statistics/ANOVA/Page.pm) perl(Statistics/Data.pm) perl(Statistics/Data/Rank.pm) perl(Statistics/DependantTTest.pm) perl(Statistics/Lite.pm) perl(Statistics/TTest.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.14
Release: alt1
Summary: Parametric and nonparametric 1-way analyses of variance for means-comparison and clustering per dif...
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RG/RGARTON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
By setting the extended Boolean (0, 1 or -1) value of only three parameters (`independent', `parametric' and `ordinal'), this module gives you oneway parametric or non-parametric analyses-of-variance (ANOVAs) for either nominal groups or ordinal levels (trend analysis), and for either independent or dependent (repeated measures) observations within each group/level. For the Fisher-esque ANOVAs, you can also access estimates of proportion of variance accounted for (*eta*-squared) and effect-size (*omega*-squared), plus *a priori* pairwise comparisons by the relevant independent or dependent *t*-tests. Non-Fisher-esque, non-parametric tests comprise the Kruskal-Wallis, Friedman and Page tests, all with default accounting for ties in the calculation of ranks, and standardizing of the test-statistics. Simple parametric and non-parametric *post hoc* clustering is also offered (Scott-Knott and Worsley methods). The module also provides for testing equality of variances (O'Brien and Levene tests) across independent groups.

A basic design principle has been to offer as few method calls as possible, and to steer queries into the proper underlying method by Boolean manipulation of a minimal parameter set. To get to any relevant test of your data, there are (only) three Boolean vars to set, and these are named adjectivally: `independent', `parametric' and `ordinal'. So the relevant tests are offered *not* in the form of little packages specific to each test, but by specifying the attributes of the data: are they based on independent groups or repeated measures? do the groups/measures form independent categories or related levels? are relationships, likenesses or differences to be found? do the data support parametric testing? It seems more useful for programmed access to statistical algorithms to be initially sensitive to the answers to these and like questions, while keeping the methods of access and set of arguments the same across tests, and the actual tests relatively invisible, rather than bearing the statistical method up-front, each package offering a unique interface and algorithm for the same things, each dependent on a unique set of arguments and their correct norder. It could be argued that that's what an application should do, not a module. This module goes the other way, recognizing that the algorithms share arguments and internal methods, which is typically obscured by algorithm-specific packaging.

Reliability has been assayed by testing each method with at least two different published sources; and comparing the output with one or another open-source or commercial statistics package. The tests based on published examples are implemented during cpan-wise installation; see the "t" folder of cpan.org's installation-distribution of this module. News of unreliabilities are welcome; a fundamental one from Cathal Seoghie has already helped, namely, by pointing to the need to account for NaNs, empty, and invalid values.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/S*

%changelog
