%define module_name Statistics-ANOVA-Friedman
# BEGIN SourceDeps(oneline):
BuildRequires: perl(List/AllUtils.pm) perl(Math/Cephes.pm) perl(Module/Build.pm) perl(Statistics/Data.pm) perl(Statistics/Data/Rank.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: nonparametric repeated measures analysis of variance for nominal variables (Friedman Test)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RG/RGARTON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Performs the Friedman nonparametric analysis of variance - for two or more dependent (matched, related) nominal variables. A ranking procedure is used, but, unlike the case for independent variables, the ranks are taken at each common index of each variable, i.e., within-groups, given that values at each index are given by the same data-source (person, plot, etc.).

By default, the method accounts for and corrects for ties, but if correct_ties => 0, the test-statistic is uncorrected. The correction involves accounting for the number of tied variables at each index, as per Hollander & Wolfe (1995), Eq. 7.8, p. 274.

The module uses Statistics::Data as a base so that data can be pre-loaded and otherwise manipulated/queried per that module's methods.

Correctness of output is tested on installation using example data from Hollander & Wolfe (1999, p. 274ff), Rice (1995, p. 470), Sarantakos (1993, p. 404-405), and Siegal (1956, p. 167ff); tests fail if the published chi-values and degrees-of-freedom are not returned by the module.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/S*

%changelog
