%define module_name Statistics-Descriptive-Discrete
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Benchmark.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.12
Release: alt1
Summary: Compute descriptive statistics for discrete data sets.
Group: Development/Perl
License: see LICENSE
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RH/RHETTBULL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides basic functions used in descriptive statistics..It borrows very heavily from Statistics::Descriptive::Full
(which is included with Statistics::Descriptive) with one major
difference.  This module is optimized for discretized data 
e.g. data from an A/D conversion that 
has a discrete set of possible values.  E.g. if your data is produced
by an 8 bit A/D then you'd have only 256 possible values in your data 
set.  Even though you might have a million data points, you'd only have
256 different values in those million points.  Instead of storing the 
entire data set as Statistics::Descriptive does, this module only stores
the values it's seen and the number of times it's seen each value.

For very large data sets, this storage method results in significant speed
and memory improvements.  In a test case with 2.6 million data points from
a real world application, Statistics::Descriptive::Discrete took 40 seconds 
to calculate a set of statistics instead of the 561 seconds required by
Statistics::Descriptive::Full.  It also required only 4MB of RAM instead of 
the 400MB used by Statistics::Descriptive::Full for the same data set.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README README.md LICENSE examples
%perl_vendor_privlib/S*
%perl_vendor_privlib/auto/*

%changelog
