%define module_name Statistics-Distribution-Generator
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(List/AllUtils.pm) perl(Statistics/Descriptive.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.003
Release: alt1
Summary: A way to compose complicated probability functions
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PW/PWBENNETT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module allows you to bake together multiple "simple" probability
distributions into a more complex random number generator. It does this lazily:
when you call one of the PDF generating functions, it makes an object, the
value of which is not calculated at creation time, but rather re-calculated
each and every time you try to read the value of the object. If you are
familiar with Functional Programming, you can think of the exported functions
returning functors with their "setup" values curried into them.

To this end, two of Perl's operators (x and |) have been overloaded with
special semantics.

The x operator composes multiple distributions at once, giving an ARRAYREF
of "answers" when interrogated, which is designed primarily to be interpreted
as a vector in N-dimensional space (where N is the number of elements in the
ARRAYREF).

The | operator composes multiple distributions into a single value, giving
a SCALAR "answer" when interrogated. It does this by picking at random between
the composed distributions (which may be weighted to give some higher
precendence than others).

*The first thing to note* is that x and | have their *normal* Perl
precendence and associativity. This means that parens are strongly advised
to make your code more readable. This may be fixed in later versions of this
module, by messing about with the the B manpage modules, but that would still not make
parens a bad idea.

*The second thing to note* is that x and | may be "nested" arbitrarily
many levels deep (within the usual memory & CPU limits of your computer, of
course). You could, for instance, compose multiple "vectors" of different sizes
using x to form each one, and select between them at random with , e.g.

    my $forwards = gaussian(0, 0.5) x gaussian(3, 1) x gaussian(0, 0.5);
    my $backwards = gaussian(0, 0.5) x gaussian(-3, 1) x gaussian(0, 0.5);
    my $left = gaussian(-3, 1) x gaussian(0, 0.5) x gaussian(0, 0.5);
    my $right = gaussian(3, 1) x gaussian(0, 0.5) x gaussian(0, 0.5);
    my $up = gaussian(0, 0.5) x gaussian(0, 0.5) x gaussian(3, 1);
    my $down = gaussian(0, 0.5) x gaussian(0, 0.5) x gaussian(-3, 1);
    my $direction = $forwards | $backwards | $left | $right | $up | $down;
    $robot->move(@$direction);

You are strongly encouraged to seek further elucidation at Wikipedia or any
other available reference site / material.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/S*

%changelog
