# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Contextual/Return.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Math/Cephes.pm) perl(Module/Build.pm) perl(Statistics/Distributions.pm) perl(Test/More.pm) perl(Text/SimpleTable.pm) perl(version.pm)
# END SourceDeps(oneline)
%define module_version 0.1.5
%define module_name Statistics-Distributions-GTest
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.5
Release: alt1
Summary: Perl implementation of the Log-Likelihood Ratio Test (G-test) of Independence.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DS/DSTH/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The G-test of independence is an alternative to the chi-square test of independence for testing for independence in
contingency tables. G-tests are coming into increasing use and as with the chi-square test for independence the G-test
for independence is used when you have two nominal variables each with two or more possible values. The null hypothesis
is that the relative proportions of one variable are independent of the second variable. This module implements two two 
equivalent, but marginally different approaches to calculate G scores (that described in 
http://en.wikipedia.org/wiki/G-test and that used by http://udel.edu/~mcdonald/statgtestind.html). Benchmarking 
indicates that first approach works about a third faster than the alternative. However, this difference 
diminishes as the categories increase. See http://en.wikipedia.org/wiki/G-test and 
http://udel.edu/~mcdonald/statgtestind.html.


%prep
%setup -n %module_name

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/S*

%changelog
