%define module_version 1.0
%define module_name Statistics-MaxEntropy
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(diagnostics.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0
Release: alt1
Summary: Perl5 module for Maximum Entropy Modeling and Feature Induction
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/T/TE/TERDOEST/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module is an implementation of the Generalised and Improved
Iterative Scaling (GIS, IIS) algorithms and the Feature Induction (FI)
algorithm as defined in (Darroch and Ratcliff 1972) and (Della
Pietra et al. 1997). The purpose of the scaling algorithms is to find
the maximum entropy distribution given a set of events and
(optionally) an initial distribution. Also a set of candidate features
may be specified; then the FI algorithm may be applied to find and add
the candidate feature(s) that give the largest `gain' in terms of
Kullback Leibler divergence when it is added to the current set of
features.

Events are specified in terms of a set of feature functions
(properties) f_1...f_k that map each event to {0,1}: an event is a
string of bits. In addition of each event its frequency is given. We
assume the event space to have a probability distribution that can be
described by

=begin roff

    p(x) = 1/Z e^{sum_i alpha_i f_i(x)}

=end roff

=begin text

    p(x) = 1/Z e^{sum_i alpha_i f_i(x)}

=end text

=begin latex

\begin{equation*}
    p(x) = \frac{1}{Z} \exp[\sum_i \alpha_i f_i(x)]
\end{equation*}
where $Z$ is a normalisation factor given by
\begin{equation*}
    Z = \sum_x \exp[\sum_i \alpha_i f_i(x)]
\end{equation*}

=end latex

=begin roff

where Z is a normalisation factor. The purpose of the IIS algorithm is
the find alpha_1..alpha_k such that D(p~||p), defined by

    D(p~||p) = 
       sum_x p~ . log(p~(x) / p(x)),

is minimal under the condition that p~[f_i] = p[f_i], for all i.

=end roff

=begin latex

The purpose of the scaling algorithms IIS GIS is
the find $\alpha_1..\alpha_k$ such that $D(\tilde{p}||p)$, defined by
\begin{equation*}
    D(\tilde{p}||p) = 
       \sum_x \tilde{p} \log (\frac{\tilde{p}(x)}{p(x)}),
\end{equation*}
is minimal under the condition that for all $i$
$\tilde{p}[f_i]=p[f_i]$.

=end latex

The module requires the `Bit::SparseVector' module by Steffen Beyer and the
`Data::Dumper' module by Gurusamy Sarathy. Both can be obtained from
CPAN just like this module.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name



%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/S*
%perl_vendor_privlib/auto/*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
