%define module_name Statistics-Sampler-Multinomial
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Clone.pm) perl(Data/Compare.pm) perl(Devel/Symdump.pm) perl(ExtUtils/MakeMaker.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(Math/Random.pm) perl(Math/Random/MT/Auto.pm) perl(Path/Tiny.pm) perl(Ref/Util.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(parent.pm) perl(rlib.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.02
Release: alt1
Summary: Generate multinomial samples using the conditional binomial method.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SL/SLAFFAN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Implements multinomial sampling using the conditional binomial method
(the same algorithm as used in the GSL).
Benchmarking shows it to be faster than the Alias
method implemented in the Statistics::Sampler::Multinomial::AliasMethod manpage,
presumably because the calls to the PRNG are inside XS and avoid
perl subroutine overheads
(and profiling showed the RNG calls to be the main bottleneck
for the Alias method).  

For more details and background about the various approaches,
see http://www.keithschwarz.com/darts-dice-coins.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md
%perl_vendor_privlib/S*

%changelog
