%define module_name Statistics-TheilSenEstimator
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Statistics/QuickMedian.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt2
Summary: Perl implementation of Theil Sen Estimator
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JI/JIMI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a perl implementation of the Theil Sen Estimator, which is a method of
linear regression that uses medians.  All of the gradients of the lines between
all points are calculated, and hte median is the one reported.  Sounds trivial.  
If you have 1000s of points, then you have millions of lines, and sort-based
median methods can take ages, so Statistics::TheilSen uses the partition-based
Statistics::QuickMedian.

    # OOP...
    
    use Statistics::TheilSenEstimator;

    my $tse = Statistics::TheilSenEstimator->new(\$y_values, \$x_values);
    # which is really a shortcut for:
    my $tse = Statistics::TheilSenEstimator->new();
    $tse->addData(\@y_values, \@x_values); # listrefs of numeric scalars
    
    my $status_line = $tse->run(); # might tell if you had bad values, etc
    print "y = ", $tse->m(), "x + ", $tse->c(); # y = mx + c
    
    # or procedural...
    
    use Statistics::TheilSenEstimator qw/theilsen/;

    my ($m,$c) = theilsen(\@y_values, \@x_values);

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/S*

%changelog
