%define module_name Story-Interact
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bytes/Random/Secure.pm) perl(Carp.pm) perl(Compress/Bzip2.pm) perl(CryptX.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Exporter/Shiny.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON/PP.pm) perl(List/Util.pm) perl(Module/Runtime.pm) perl(Moo.pm) perl(Term/Choose.pm) perl(Test2/Require/AuthorTesting.pm) perl(Test2/Require/Module.pm) perl(Test2/Tools/Spec.pm) perl(Test2/V0.pm) perl(Text/Wrap.pm) perl(Types/Common.pm) perl(Types/Path/Tiny.pm) perl(URI/Query.pm) perl(match/simple.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001014
Release: alt1
Summary: tools for writing (and reading) an interactive story
Group: Development/Perl
License: perl
URL: https://story-interact.xlc.pl/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Story::Interact is for choose-your-own-adventure-style stories, but with a
difference. Pages can alter a global "state". This allows your character to
achieve things, and those achievements alter the course of the story later
on. This elevates stories to a full text-based game.

Documentation is currently very limited. Tests are almost non-existent.

Stories are written in pages. Each page is a Perl script using the functions
defined in the Story::Interactive::Syntax manpage. They may contain arbitrary Perl
code.

Stories may contain arbitrary Perl code. Do not run untrusted stories.

An example page:

  at 'kitchen';
  
  text "You are in the kitchen.";
  
  unless ( location->{apple_gone} ) {
   text "There is an *apple* on the counter.";
   next_page apple => 'Pick up apple';
  }
  
  next_page living_room => 'Go to the living room';

The `text' function is just to add a paragraph of text. (It may use simple
Markdown for **bold** and **italics**.) Pages can of course contain
multiple paragraphs.

The `next_page' function defines a path the story can take after this page.
It takes a page identifier followed by a description. It can be used multiple
times to present the user with a choice. If a page has no next page, then
it is an end to the story. (The `next_page' function can actually be called
as `next_page( $id, $description, %%metadata )' though this metadata is
not currently used for anything! In future versions it might be used to
allow shortcut keys for certain choices, etc.)

The `at' function should be used at the top of a page to indicate what place
this page occurs at. It is an arbitrary string, so could be a room name,
grid co-ordinates, etc. Multiple pages may be written for the same location.

The `location' function returns a hashref associated with this location.
This can be used to store state for this location. You can use
`location( $string )' to access another location's hashref; the
string match must be exact.

The `world' function returns a hashref for storing story-wide state.

The...

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYRIGHT CREDITS README Changes LICENSE examples
%perl_vendor_privlib/S*

%files scripts
%_bindir/*

%changelog
