%define module_name StreamFinder
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTML/Entities.pm) perl(LWP/UserAgent.pm) perl(Test/More.pm) perl(URI/Escape.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.43
Release: alt1
Summary: Fetch actual raw streamable URLs from various radio-station websites.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TU/TURNERJW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
StreamFinder accepts a valid radio station URL on supported websites and
returns the actual streamurl, title, and cover art icon for that station.  
The purpose is that one needs one of these URLs 
in order to have the option to stream the station in one's own choice of 
audio player software rather than using their web browser and accepting any / 
all flash, ads, javascript, cookies, trackers, web-bugs, and other crapware 
that can come with that method of playing.  The author uses his own custom 
all-purpose audio player called "fauxdacious" (his custom hacked version of 
the open-source "audacious" media player).  "fauxdacious" incorporates this 
module to decode and play streams.  The currently-supported websites are:
radionomy.com, iheartradio.com, reciva.com, facebook, and youtube / vimeo. 
We used to support tunein.com, but they have now borked up their pages to 
make it nearly impossible to obtain their hidden streams programatically.

It amazes me the effort to which marketing-run operations will go to and 
web-development money they'll spend to prevent people from accessing their 
radio streams in alternate ways, even though the content is already paid for 
by the advertisements already played in the streams.  Guess they are that 
desparate to track your web-activity, store crap in cookies on your browser, 
and pummel you to death with evem more useless add garbage.  Our mission is 
to restore your freedom to access commercial and other streaming radio 
stations that already paid for and freely available over the air in the ways 
most convenient to YOU, the listener!  We are NOT in the business to 
provide a means of circumventing copyright laws, however!

Each site is supported by a separate subpackage (StreamFinder::*Package*), 
which is determined and selected based on the url when the StreamFinder object 
is created.  The methods are overloaded by the selected subpackage's methods.

One or more playable streams can be returned for each station.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/S*

%changelog
