# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Exporter.pm) perl(fields.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    String-CRC-Cksum
%define upstream_version 0.91

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_10

Summary:    Perl extension for calculating checksums
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/String/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildArch: noarch
Source44: import.info

%description
The String::CRC::Cksum module calculates a 32 bit CRC, generating the same
CRC value as the POSIX cksum program. If called in a list context, returns
the length of the data object as well, which is useful for fully emulating
the cksum program. The returned checksum will always be a non-negative
integral number in the range 0..2^32-1.

Despite its name, this module is able to compute the checksum of files as
well as of strings. Just pass in a reference to a filehandle, or a
reference to any object that can respond to a read() call and eventually
return 0 at "end of file".

Beware: consider proper use of binmode() if you are on a non-UNIX platform
or processing files derived from other platforms.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc README Changes
%perl_vendor_privlib/*




%changelog
