# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Config.pm) perl(Exporter/Shiny.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test2/V0.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_name String-Compile-Tr
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: compile tr/// expressions
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SO/SOMMREY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The usual approach when operands of a `tr///' operator shall be
variables is to apply `eval' on a string to interpolate the operands.
The drawback of this approach are possible unwanted side effects induced
by the variables' content, e.g.

    $search = '//,warn-trapped,$@=~tr/';
    eval "tr/$search//d";

`String::Compile::Tr' offers an alternative where the content of a
variable can be used as operand without `eval''ing it. 
Instead the operands of a `tr///' operator are overloaded at runtime
inside a constant `eval '...''.

`trgen(*SEARCH*, *REPLACE*, *OPT*)' compiles an anonymous sub that
performs almost the same operation as `tr/*SEARCH*/*REPLACE*/*OPT*',
but allows variable operands.

`trgen' is imported by default by `use String::Compile::Tr'.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE CONTRIBUTING.md README
%perl_vendor_privlib/S*

%changelog
