%define module_name String-Interpolate-Named
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt1
Summary: Interpolated named arguments in string
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JV/JV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
String::Interpolate::Named exports a single function, `interpolate', that
takes a string and substitutes named *variables* by *target texts*.

The subroutine takes two arguments: a reference to a control hash and
the string.

The arguments to be replaced are marked in the string by enclosing
them between `%%{' and `}'. For example, the string `"The famous
%%{fn} %%{ln}."' contains two named arguments, `fn' and `ln'.

In its basic form, the `%%{var}' is replaced by the value of the key
`var' in the `args' element of the control hash. It is also possible
to specify replacement values depending on whether `var' has a
value or not:

    "This book has %%{title|title %%{title}}"
    "This book has %%{title|title %%{title}|no title}"

Assuming argument `title' has the value `"My Book"', in the first
example the text `"title My Book"' will be substituted. If `title'
does not have a value, the empty string is substituted.

In the second example, the string `"no title"' will be substituted.

As can be seen, the replacement texts may contain interpolations as
well. For convenience, you can use `%%{}' to refer to the value of the
named variable currently being examinated. The last example above can
be written more shortly and elegantly as:

    "This book has %%{title|title %%{}|no title}"

You can test for specific values:

    "This takes %%{days=1|%%{} day|%%{} days}"

Finally, the values as specified in the control hash may be scalar (in
general: strings and numbers) or lists of scalars. If a value is a
list of scalars, it is possible to select a value from the list by
appending a period and a number to the key. Assume `customer' has
value `[ "Jones", "Smith" ]', then:

    "%%{customer.1} will be Smith"
    "%%{customer.2} will be Jones"
    "%%{customer} will be Jones Smith"

The control hash contains the values for the variables in `"args"':

    { args => { customer => [ "Jones", "Smith" ],
                days => 2, ... },
    }

When list values need to be concatenated, a separator may be
specified:

    { args => { custom...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/S*

%changelog
