%define module_name String-Interpolate-Shell
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Params/Check.pm) perl(Test/More.pm) perl(Text/Balanced.pm) perl(base.pm) perl(blib.pm) perl(if.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: - Variable interpolation, shell style
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DJ/DJERIUS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
String::Interpolate::Shell interpolates variables into strings.
Variables are specified using a syntax similar to that use by bash.
Undefined variables can be silently ignored, removed from the string,
can cause warnings to be issued or errors to be thrown.

=over

=item $*varname*

Insert the value of the variable.


=item ${*varname*}

Insert the value of the variable.

=item ${*varname*:?error message}

Insert the value of the variable.  If it is not defined,
the routine croaks with the specified message.

=item ${*varname*:-*default text*}

Insert the value of the variable.  If it is not defined,
process the specified default text for any variable interpolations and
insert the result.

=item ${*varname*:+*default text*}

If the variable is defined, insert the result of interpolating
any variables into the default text.

=item ${*varname*:=*default text*}

Insert the value of the variable.  If it is not defined,
insert the result of interpolating any variables into the default text
and set the variable to the same value.


=item ${*varname*::*format*}

Insert the value of the variable as formatted according to the
specified sprintf compatible format.

=item ${*varname*:~*op*/*pattern*/*replacement*/msixpogce}

Insert the modified value of the variable.  The modification is
specified by *op*, which may be any of `s', `tr', or `y',
corresponding to the Perl operators of the same name. Delimiters for
the modification may be any of those recognized by Perl.  The
modification is performed using a Perl string eval.

=back

In any of the bracketed forms, if the variable name is preceded with an exclamation mark (`!')
the name of the variable to be interpreted is taken from the value of the specified variable.



%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/S*

%changelog
