%define module_name String-InterpolatedVariables
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Readonly.pm) perl(Test/Deep.pm) perl(Test/FailWarnings.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.000000
Release: alt1
Summary: Extract variable names from interpolated strings.
Group: Development/Perl
License: perl
URL: https://github.com/oalders/String-InterpolatedVariables

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/O/OA/OALDERS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
String::InterpolatedVariables offers a way to extract the name of the variables
that are present in interpolated strings.

This is particularly useful if you are using the PPI manpage to parse Perl documents,
and you want to know what variables would be interpolated inside the
the PPI::Token::Quote::Double manpage and the PPI::Token::Quote::Interpolate manpage objects you
find there. A practical example of this use can be found in
the Perl::Critic::Policy::ValuesAndExpressions::PreventSQLInjection manpage.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTORS LICENSE Changes README.md example
%perl_vendor_privlib/S*

%changelog
