# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(IO/File.pm) perl(Inline.pm) perl(Storable.pm) perl(Test/More.pm) perl(Parse/RecDescent.pm)
# END SourceDeps(oneline)
%define module_version 0.079
%define module_name String-Simrank
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.079
Release: alt1
Summary: Rapid comparisons of many strings for k-mer similarity.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SH/SHURIKO/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The String::Simrank module allows rapid searches for similarity between query.strings and a database of strings.  This module is maintained by molecular
biologists who use it for searching for similarities among strings representing
contiguous DNA or RNA sequences.  This program does not
construct an alignment but rather finds the ratio
of nmers (A.K.A. ngrams) that are shared between a query and database
records.
The input file should be fasta formatted (either aligned or unaligned) multiple
sequence file.  
The memory consumption is moderate and grows linearly with the number of sequences
and depends on the nmer size defined by the user.  Using 7-mers, ~20,000 strings
each ~1,500 characters in length requires ~50 Mb.

The module can be used from the command line through the script
`simrnak_nuc.pl' provided in the examples folder.

By default the output is written to STDOUT and
represents the similarity of each query string to the top hits in the 
the database.  The format is query_id, tab, best match database_id, colon, percent similarity, space
second best match database_id, colon, percent similarity.
query1  EscCol36:100.00 EscCol36:100.00 EscCol43:99.59  EscCol29:99.24  EscCol33:99.17  EscCol10:99.02 


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/S*

%changelog
