# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(String/Random.pm) perl(Test.pm) perl(Test/Differences.pm) perl(Test/Exception.pm) perl(Test/ManyParams.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name String-Substrings
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: module to extract some/all substrings from a string
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BI/BIGJ/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module has only one method `substrings'.
It is called as

  substrings STRING [,LENGTH]
  
Without a length specification,
tt returns all substrings with a length of 1 or greater 
including the string itselfs. The substrings returned are
sorted for the length (starting with length 1) and for their index.
E.g. `substrings "abc"' returns `("a","b","c","ab","bc","abc")'.
This order is guaranteed to stay even in future versions.
That also includes that the returned list of substrings needn't be unique.
E.g. `substrings "aaa"' returns `("a","a","a","aa","aa","aaa")'.

With a length specification,
it returns only substrings of this length.
This notion is equivalent to
`grep {length($_) == $length} substrings $string'.

`substrings ""' returns an empty list,
`substrings undef' returns undef and
every call with a hash/array-reference let substrings die.

In scalar context it returns the number of substrings found,
allthough I can't imagine that it is useful. (It's simple to calculate
without determining all the substrings: 
`length($string) * (length($string)+1) / 2'.
Especially the scalar context behavior could be changed in future versions.

Please take care to the length of the strings passed.
The number of substrings grows with the square of the string's length.
I only tested it till a string length of 100.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/S*

%changelog
