# BEGIN SourceDeps(oneline):
BuildRequires: perl(B/CompilerPhase/Hook.pm) perl(Module/Build.pm) perl(Sub/Util.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Sub-Attribute-Prototype
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: polyfill for C<:prototype> attribute on older perls
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PEVANS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This polyfill allows a module to use the `:prototype' function attribute to
apply a prototype to a function, even on perls too old to natively support it.

Perl version 5.20 introduced the `:prototype' attribute, as part of the wider
work surrounding subroutine signatures. This allows a function to declare a
prototype even when the `use feature 'signatures'' pragma is in effect.

If a newer version of perl switches the defaults to making signature syntax
default, it will no longer be possible to write prototype-using functions
using the old syntax, so authors will have to use `:prototype' instead. By
using this polyfill module, an author can ensure such syntax is still
recognised by perl versions older than 5.20.

When used on a version of perl new enough to natively support the
`:prototype' attribute (i.e. 5.20 or newer), this module does nothing. Any
`:prototype' attribute syntax used by the user of this module is simply
handled by core perl in the normal way.

When used on an older version of perl, a polyfilled compatibility attribute
is provided to the caller to (mostly) perform the same work that newer
versions of perl would do; subject to some caveats.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE
%perl_vendor_privlib/S*

%changelog
