# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(experimental.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name Sub-Deprecate
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Enables runtime graceful deprecation notices on sub calls
Group: Development/Perl
License: artistic_2
URL: https://github.com/EvanCarroll/perl-sub-deprecate

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/EC/ECARROLL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module will assist in providing a more graceful deprecation when you
can't control all your users.

    use experimental 'signatures';
    use Sub::Deprecate qw(sub_rename_with sub_trigger_once_with);
    
    sub foo { 7 };
    sub_trigger_once_with( __PACKAGE__, 'foo', sub ($target) { warn "Triggered!" } );
    # foo() # will trigger cb event
    
    
    sub fancy_new { 7 }
    sub_rename_with( __PACKAGE__, 'old_and_deprecated', 'fancy_new', sub ($old, $new) { warn "sub old_and_deprecated is deprecated" } );
    old_and_deprecated() # will warn and redirect to fancy_new

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/S*

%changelog
