%define module_version 0.002
%define module_name Sub-Lazy
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Attribute/Handlers.pm) perl(Data/Thunk.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(if.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: defer calculating subs until necessary
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Sub-Lazy

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Sub::Lazy allows you to mark subs as candidates for lazy evaluation..Good candidates for lazy evaluation:

=over

=item *

Have no side-effects. They don't alter global variables; they don't
make use of any closed-over lexical variables; they don't do IO or
make system calls.

=item *

Are only called in scalar context. This module always imposes a
scalar context on subs. (Of course the sub can return an arrayref.)

=back

The actual work is done by the Data::Thunk manpage. Data::Thunk is awesome but
it does have its limitations. It's not completely transparent (if you
try hard enough, you can tell the difference between a value that has
not been calculated yet and one that has) and it will sometimes be
over-eager to calculate a value. But it's probably the best solution
for lazy scalars on CPAN, so I've reused it rather than writing a
half-arsed replacement for it.

This module defines an atttribute (`:Lazy') to allow you to wrap
a sub with Data::Thunk, making the whole business a little easier.

If your function is known to always return an instance of a particular
class, then you can specify that:

   sub get_manager :Lazy(class=>Person) {
      ...;
   }

Sub::Lazy will then use Data::Thunk's `lazy_object' feature, which
allows Data::Thunk to further postpone evaluation of the sub in some
cases.

You can even patch in further details about the object you are
returning:

   sub get_manager :Lazy(class=>Person,job_title=>"Manager") {
      ...;
   }

Now `get_manager(...)->job_title' will return `"Manager"'
without needing to evaluate `get_manager'.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE COPYRIGHT
%perl_vendor_privlib/S*

%changelog
