# BEGIN SourceDeps(oneline):
BuildRequires: perl(B.pm) perl(B/Utils.pm) perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(FileHandle.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(YAML.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Sub-PatMat
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: call a version of subroutine depending on its arguments
Group: Development/Perl
License: bsd
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GR/GRUBER/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The `Sub::PatMat' module provides the programmer with the ability 
to define a subroutine multiple times and to specify what version
of the subroutine should be called, depending on the parameters
passed to it (or any other condition).

This is somewhat similar to argument pattern matching facility
provided by many programming languages.

To use argument pattern matching on a sub, the programmer has to specify
the `when' attribute.  The parameter to the attribute must be
a single Perl expression.

When the sub is called, those expressions are evaluated
consequitively until one of them evaluates to a true value.
When this happens, the corresponding version of a sub is
called.

If none of the expressions evaluates to a true value, a
Bad Match exception is thrown.

It is possible to specify a fall-back version of the
function by doing one of the following:

=over

=item specifying `when' without an expression

=item specifying `when' with an empty expression

=item not specifying the `when' attribute at all

=back

Please note that it does not make sense to specify any
non-fall-back version of the sub after the fall-back
version, since such will never be called.

There is an additional limitation for the last form of
the fall-back version (the one without the `when' attribute at all),
namely, it must be the last version of the sub defined.

It is possible to specify named sub parameters in the
`when'-expression.  This facility is highly experimental
and is currently limited to scalar parameters only.
The named sub parameters are extracted from expressions
of the form

  my (parameter list) = @_;

anywhere in the body of the sub.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/S*

%changelog
