%define module_name Submodules
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0015
Release: alt1
Summary: Efficient way to load or handle all submodules for a specific package.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/Z/ZA/ZARABOZO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module will walk the paths that Perl itself walks whenever a module is used or required
and will return all the submodules found for a specific package (or the current package if none is
specified).

This is useful for many different cases. For example, when you work on a module that is always going
to use or require all of its submodules. Suppose the module *MyModule* has many submodules
that is going to use from the beggining (e.g. *MyModule::Protocol*, *MyModule::Result*,
*MyModule::Config*, *MyModule::Plugins*, and so on). You would then normally write something like:

    package MyModule;
    use MyModule::Protocol;
    use MyModule::Result;
    use MyModule::Config;
    use MyModule::Plugins;
    use MyModule::Plugins::PlugA;
    use MyModule::Plugins::PlugB;
    use MyModule::Plugins::PlugC;
    use MyModule::SomethingElse;
    # ...and so on with all of your submodules

Now, imagine you constantly add submodules and you need to keep this list updated too. Instead, you
can use this module in a very efficient way:

    package MyModule;
    use Submodules;
    for my $i (Submodules->find) {
        $i->require;
    }
    
    # Maybe you need to do the same for
    # a package different than the current:
    
    for my $i (Submodules->find('LWP')) { # All LWP & LWP submodules
        $i->require;
    }
    
    # Or maybe you only want a subset:
    
    for my $i (Submodules->find('LWP::Protocol')) { # All LWP protocols
        $i->require;
    }

Not only that will save you lots of lines, but it will always include new submodules without you having
to go back to this one to include them.

Each of the elements returned by the find method is an instance of the Submodules::Result manpage,
which is automagically stringified to the name of the module (as in Some::Module) but has
useful methods that can do a lot more.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/S*

%changelog
