%define module_version 0.006
%define module_name Syntax-Collector
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(Exporter/Tiny.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Runtime.pm) perl(Scalar/Util.pm) perl(Test/Builder.pm) perl(Test/Builder/Module.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1
Summary: collect a bundle of modules into one
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Syntax-Collector

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Perl is such a flexible language that the language itself can be extended
from within. (Though much of the more interesting stuff needs XS hooks like
the Devel::Declare manpage.)

One problem with this is that it often requires a lot of declarations at the
top of your code, loading various syntax extensions. The the syntax manpage module on
CPAN addresses this somewhat by allowing you to load a bunch of features in
one line, provided each syntax feature implements the necessary API:

  use syntax qw/io maybe perform/;

However this introduces problems of its own. If we look at the code above,
it is non-obvious that it requires the Syntax::Feature::Io manpage,
the Syntax::Feature::Maybe manpage and the Syntax::Feature::Perform manpage, which makes
it difficult for automated tools such as the Module::Install manpage to automatically
calculate your code's dependencies.

Syntax::Collector to the rescue!

  package Example::ProjectX::Syntax;
  use 5.010;
  use Syntax::Collector -collect => q/
  use strict 0;
  use warnings 0;
  use feature 0 ':5.10';
  use Scalar::Util 1.21 qw(blessed);
  /;

When you `use Syntax::Collector', you provide a list of modules to
"collect" into a single package (notice the `q/.../'). This list
of modules looks like a big string of Perl code that is going to be
passed to `eval', but don't let that fool you - it is not.

Each line must conform to the following pattern:

  (use|no) MODULENAME VERSION (OTHERSTUFF)? ;

(Actually hash comments, and blank lines are also allowed.) The semantics
of all that is pretty much what you'd expect, except that when MODULENAME
begins with "Syntax::Feature::" it's treated with some DWIMmery, and
`install' is called instead of `import'. Note that VERSION is required,
but if you don't care which version of a module you use, it's fine to
set VERSION to 0. (Yes, VERSION is even required for pragmata.)

Now, you ask... why stuff all that structured data into a string, and
parse it out again? Because to naive lexical analysis (e.g.
the Module::Install manpage) it really looks like a bunch of "use" lines, and
not just a single quoted string. This helps tools calculate the
dependencies of your collection; and thus the dependencies of other
code that uses your collection.

Because Syntax::Collector provides an `import' method for your collection
package, you cannot provide your own. However, the `import' method
provided will automatically call an `IMPORT' method if it exists.
`IMPORT' is passed a copy of the same arguments that were passed to
`import'. (And indeed, it is invoked using `goto' so it should be
safe to check `caller(0)'.)

As well as providing an `import' method for your collection,
Syntax::Collector also provides a `modules' method, which can be called
to find out which modules a collection includes. Called in list context,
it returns a list. Called in scalar context, it returns a reference to a
`{ module => version }' hash.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README COPYRIGHT LICENSE Changes examples
%perl_vendor_privlib/S*

%changelog
