Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Syntax-Highlight-Perl6
Version:        0.88
Release:        alt2_38
Summary:        Perl 6 Syntax Highlighter
License:        ( GPL-1.0-or-later OR Artistic-1.0-Perl ) AND Artistic-2.0 AND ( MIT OR GPL-2.0-only )
URL:            https://metacpan.org/release/Syntax-Highlight-Perl6
Source0:        https://cpan.metacpan.org/authors/id/A/AZ/AZAWAWI/Syntax-Highlight-Perl6-%{version}.tar.gz
BuildArch:      noarch

BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(File/ShareDir/Install.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(feature.pm)
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(File/ShareDir.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(Getopt/Long.pm)
BuildRequires:  perl(IO/File.pm)
BuildRequires:  perl(open.pm)
BuildRequires:  perl(STD.pm)
BuildRequires:  perl(Term/ANSIColor.pm)
BuildRequires:  perl(utf8.pm)
# Tests
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(English.pm)
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(IPC/Open2.pm)
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/More.pm)
Requires:       perl(Encode.pm)
Requires:       perl(File/ShareDir.pm)
Requires:       perl(File/Temp.pm)
Requires:       perl(Getopt/Long.pm)
Requires:       perl(IO/File.pm)
Requires:       perl(STD.pm) >= 32116
Requires:       perl(Term/ANSIColor.pm)


Source44: import.info
%filter_from_requires /^perl(STD\\)\s*$/d

%description
Syntax::Highlight::Perl6 parses Perl 6 source code using an embedded
STD.pm. It matches parse tree nodes to colors then returns them in
different output formats. It can be used to create web pages with colorful
source code samples in its simple and snippet HTML modes, or it can be used
as a learning tool in examining STD.pm's output using the JavaScript node
viewer in its full HTML mode. Or you can use its parse tree Perl 5 records
to build your next great idea.

%prep
%setup -q -n Syntax-Highlight-Perl6-%{version}

%build
CFLAGS="$RPM_OPT_FLAGS" perl Makefile.PL INSTALLDIRS=perl \
    NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build} OPTIMIZE="$RPM_OPT_FLAGS"

%install
%{makeinstall_std}
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_privlib}/Syntax*
%{perl_vendor_privlib}/auto/*
%{_bindir}/hilitep6
%{_mandir}/man1/hilitep6*

%changelog
