%define module_name Syntax-Keyword-Finally
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/CBuilder.pm) perl(Module/Build.pm) perl(Syntax/Keyword/Try.pm) perl(Test/More.pm) perl(XSLoader.pm) perl(feature.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt2
Summary: add C<FINALLY> phaser block syntax to perl
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PEVANS/%{module_name}-%{version}.tar.gz

%description
This module provides a syntax plugin that implements a phaser block that
executes its block when the containing scope has finished. The syntax of the
`FINALLY' block looks similar to other phasers in perl (such as `BEGIN'),
but the semantics of its execution are different.

The operation can be considered a little similar to an `END' block, but with
the following key differences:

=over 2

=item *

A `FINALLY' block runs at the time that execution leaves the block it is
declared inside, whereas an `END' block runs at the end time of the entire
program regardless of its location.

=item *

A `FINALLY' block is invoked at the time its containing scope has finished,
which means it might run again if the block is entered again later in the
program. An `END' block will only ever run once.

=item *

A `FINALLY' block will only take effect if execution reaches the line it is
declared on; if the line is not reached then nothing happens. An `END' block
will always be invoked once declared, regardless of the dynamic extent of
execution at runtime.

=back

`FINALLY' blocks are primarily intended for cases such as resource
finalisation tasks that may be conditionally required.

For example in the synopsis code, after normal execution the statement handle
will be finished using the `$sth->finish' method, then the database will
be disconnected with `$dbh->disconnect'. If instead the prepare method
failed then the database will still be disconnected, but there is no need to
finish with the statement handle as the second `FINALLY' block was never
encountered.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_archlib/S*
%perl_vendor_autolib/*

%changelog
