%filter_from_requires /^perl.Sys.Cmd.Mo.pm./d
%define module_name Sys-Cmd
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Cwd.pm) perl(Data/Dumper.pm) perl(Exporter/Tidy.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/MakeMaker/CPANfile.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(File/Which.pm) perl(File/chdir.pm) perl(IO/Handle.pm) perl(Log/Any.pm) perl(Proc/FastSpawn.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.99.0
Release: alt1
Summary: run a system command or spawn a system processes
Group: Development/Perl
License: gpl
URL: https://github.com/mlawren/p5-Sys-Cmd

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ML/MLAWREN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Sys::Cmd lets you run system commands and capture their output, or
spawn and interact with a system process through its `STDIN',
`STDOUT', and `STDERR' file handles. The following functions are
exported on demand by this module:

=over 4

=item run( @cmd, [\%%opt] ) => $output | @output

Execute `@cmd' and return what the command sent to its `STDOUT',
raising an exception in the event of error. In array context returns a
list instead of a plain string.

The first element of `@cmd' will be looked up using the File::Which manpage if
it doesn't exist as a relative file name is is a CODE reference (UNIX
only).  The command input and environment can be modified with an
optional hashref containing the following key/values:

=over 4

=item dir

The working directory the command will be run in.

=item encoding

An string value identifying the encoding of the input/output
file-handles. Defaults to 'utf8'.

=item env

A hashref containing key/values to be added to the current environment
at run-time. If a key has an undefined value then the key is removed
from the environment altogether.

=item input

A string which is fed to the command via its standard input, which is
then closed.

=back

=item runx( @cmd, [\%%opt] ) => $outerrput | @outerrput

The same as the `run' function but with the command's `STDERR' output
appended to the `STDOUT' output.

=item spawn( @cmd, [\%%opt] ) => Sys::Cmd

Return a Sys::Cmd object (documented below) representing the process
running @cmd, with attributes set according to the optional \%%opt
hashref.  The first element of the `@cmd' array is looked up using
the File::Which manpage if it cannot be found in the file-system as a relative
file name or it is a CODE reference (UNIX only).

=back

Sys::Cmd objects can of course be created using the standard `new'
constructor if you prefer that to the `spawn' function:

    $proc = Sys::Cmd->new(
        cmd => \@cmd,
        dir => '/',
        env => { SOME => 'VALUE' },
        enc => 'iso-8859-3',
        input => 'feedme',
        on_exit => sub {
            my $proc = shift;
            print $proc->pid .' exited with '. $proc->exit;
        },
    );

Note that Sys::Cmd objects created this way will not lookup the
command using the File::Which manpage the way the `run', `runx' and `spawn'
functions do.

Sys::Cmd uses the Log::Any manpage `debug' calls for logging purposes.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README TODO Changes
%perl_vendor_privlib/S*

%changelog
