# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm)
# END SourceDeps(oneline)
%define module_version 0.84
%define module_name System2
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.84
Release: alt1
Summary: like system(), but with access to STDOUT and STDERR.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RE/REICHERT/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The module presents an interface for executing a command, and
gathering the output from STDOUT and STDERR.

Benefits of this interface:

=over 2

=item -

the Bourne shell is never implicitly invoked: saves a stray exec(),
and bypasses those nasty shell quoting problems.

=item -

cheaper to run than open3().

=item -

augmented processing of arguments, to allow for overriding arg[0]
(eg. initiating a login shell).

=back

STDOUT and STDERR are returned in scalars.  $? is set.  (Split on
$/ if you want the expected lines back.)

If $debug is set, on-the fly diagnostics will be reported about
how much data is being read.

Provides for convenience, a routine exit_status() to break out the
exit value into separate scalars, straight from perlvar(1):

=over 2

=item -

the exit value of the subprocess

=item -

which signal, if any, the process died from

=item -

reports whether there was a core dump.

=back

There are two interfaces available:  a regular list, or named
parameters:

These are equivalent:

  my @args = ( '/bin/sh', '-x', '-c', 'echo $0' );

  my @args = ( path => '/bin/sh', args => [ '-c', 'echo $0' ] );

To override arg[0], pass in a arrayref for the first argument, or
use the arg0 named parameter.  Contrast the prior argument lists
with these below:

  my @args = ( ['/bin/sh', '-sh'], '-c', 'echo $0' );

  my @args = ( path => '/bin/sh', args => ['-c', 'echo $0'],
               arg0 => '-sh' );


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install
rm -f %buildroot%perl_vendor_privlib/io_test.pl

%files
%doc LICENSE Changes README
%perl_vendor_privlib/S*
%perl_vendor_privlib/auto/*

%changelog
