Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: gcc-c++ perl(Bit/Vector/Overload.pm) perl(HTML/Entities.pm) perl(HTML/TableExtract.pm) perl(Pod/Usage.pm) perl(Verilog/Language.pm) perl-podlators texinfo
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# If the emacs-el package has installed a pkgconfig file, use that to determine
# install locations and Emacs version at build time, otherwise set defaults.
%if %($(pkg-config emacs) ; echo $?)
%global emacs_version 22.1
%global emacs_lispdir  %{_datadir}/emacs/site-lisp
%global emacs_startdir %{_datadir}/emacs/site-lisp/site-start.d
%else
%global emacs_version  %{expand:%(pkg-config emacs --modversion)}
%global emacs_lispdir  %{expand:%(pkg-config emacs --variable sitepkglispdir)}
%global emacs_startdir %{expand:%(pkg-config emacs --variable sitestartdir)}
%endif

Name:           perl-SystemC-Vregs
Version:        1.470
Release:        alt2_30
Summary:        Utility routines used by vregs

License:        LGPLv3+ or Artistic 2.0
URL:            https://metacpan.org/release/SystemC-Vregs
Source0:        https://cpan.metacpan.org/authors/id/W/WS/WSNYDER/SystemC-Vregs-%{version}.tar.gz

BuildArch:      noarch

BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  readline-devel
# Tests are disabled
# Run-time:
# perl(base)
# perl(Bit::Vector)
# perl(Bit::Vector::Overload)
# perl(Data::Dumper)
# File::Basename
# FindBin
# perl(Getopt::Long)
# perl(HTML::Entities)
# perl(HTML::TableExtract)
# perl(IO::File)
# perl(lib)
# perl(Pod::Usage)
# strict
# vars
# perl(Verilog::Language) >= 2.1
# warnings
# Tests:
# Config
# ExtUtils::Manifest
# perl(Test)

Requires:       perl(Verilog/Language.pm) >= 2.100

# Remove under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(Verilog.Language.pm)/d

%description
A Vregs object contains a documentation "package" containing enumerations,
definitions, classes, and registers.


%package -n     emacs-vregs-mode
Group: Development/Other
Summary:        Elisp source files for systemc-vregs under GNU Emacs
BuildRequires:  emacs-common
BuildRequires:  emacs

%description -n emacs-vregs-mode
This package provides emacs support for systemc-vregs

%prep
%setup -q -n SystemC-Vregs-%{version}

# fixing error: ‘strchr’ was not declared in this scope
perl -pi -e 's|#include <stdlib.h>|#include <stdlib.h>\n#include <string.h>|' \
  include/VregsRegInfo.cpp


%build
perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="%{optflags}" \
    NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
find %{buildroot} -type f -name '*.bs' -size 0 -delete

emacs -batch -f batch-byte-compile vregs-mode.el
install -d %{buildroot}%{emacs_lispdir}
install -pm 0644 vregs-mode.el vregs-mode.elc %{buildroot}%{emacs_lispdir}/

# %{_fixperms} %{buildroot}/*

%files
%doc --no-dereference COPYING
%doc Changes README vregs_spec.doc vregs_spec.htm
%{_bindir}/vreg*

%dir %{perl_vendor_privlib}/SystemC
%{perl_vendor_privlib}/SystemC/Vregs.pm
%{perl_vendor_privlib}/SystemC/vregs_spec__rules.pl

%dir %{perl_vendor_privlib}/SystemC/Vregs
%{perl_vendor_privlib}/SystemC/Vregs/*
%{_mandir}/man?/*

%files -n emacs-vregs-mode
%doc --no-dereference COPYING
%{emacs_lispdir}/vregs-mode.el*

%changelog
