# BEGIN SourceDeps(oneline):
BuildRequires: perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(HTML/Entities.pm) perl(HTML/Parser.pm) perl(TAP/Formatter/Console.pm) perl(TAP/Formatter/Console/Session.pm) perl(TAP/Harness.pm) perl(TAP/Parser/ResultFactory.pm) perl(Test/More.pm) perl(Test/XML.pm) perl(XML/LibXML.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_version 1.01
%define module_name TAP-Formatter-BambooExtended
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: Harness output delegate for Atlassian's Bamboo CI server
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PL/PLOCKABY/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
`TAP::Formatter::BambooExtended' provides JUnit output formatting for `TAP::Harness',
which can be used in Atlassian's Bamboo CI server or any other CI server that
looks for JUnit files.

This module is based on TAP::Formatter::Bamboo by Piotr Piatkowski
<pp@idea7.pl>, main differences are:

=over

=item Resulting XML is saved as one output file per source test script.

=item Each test gets its own result line in the JUnit output rather than
grouping all the tests from one test script into one result.

=item A summary test result is appended to indicate if there were any problems
with the test script itself outside of individual tests.

=item Output of failed tests are attached to the test that failed AND the test
script itself. Each test script will create one JUnit compatible test result
file. The test result file names will match the full path and file name of the
test script. By default these files are created in a directory called
`prove_db' that is created in your current working directory. This can be
changed by setting the environment variable `FORMATTER_OUTPUT_DIR' to a
relative or absolute path.

=back

By way of example, when you run a test like this:

    prove -l --formatter TAP::Formatter::BambooExtended

You might see these results on the command line:

    PASS t/00-load.t
    ALL DONE

Then you'll see a new directory called `$ENV{'FORMATTER_OUTPUT_DIR'}'. By
default, this directory will be created as `prove_db' in your current working
directory. In the output directory you'll see one file for each test script,
like this:

    > ls
    t-00-load_t.xml

In that file you will see one test output for the file itself, named after the
file. You'll also see one test output for each individual test in the test
script. So if your test script has twenty `ok' statements, you'll have twenty-
one tests in Bamboo -- one for the file itself and then one for each `ok'
statement. This makes it easier to track exactly which tests are failing with
Bamboo.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/T*

%changelog
