%define module_name TOML-Tiny
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper.pm) perl(DateTime.pm) perl(DateTime/Format/ISO8601.pm) perl(DateTime/Format/RFC3339.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Math/BigInt.pm) perl(TOML/Parser.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test2/V0.pm) perl(Types/Serialiser.pm) perl(charnames.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.20
Release: alt1
Summary: a minimal, pure perl TOML parser and serializer
Group: Development/Perl
License: perl
URL: https://github.com/sysread/TOML-Tiny

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/O/OA/OALDERS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`TOML::Tiny' implements a pure-perl parser and generator for the
TOML data format. It conforms to TOML v5
(with a few caveats; see the strict_arrays entry elsewhere in this document) with support for more recent
changes in pursuit of v6.

`TOML::Tiny' strives to maintain an interface compatible to the the TOML manpage and
the TOML::Parser manpage modules, and could even be used to override `$TOML::Parser':

  use TOML;
  use TOML::Tiny;

  local $TOML::Parser = TOML::Tiny->new(...);
  say to_toml(...);

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/T*

%changelog
