Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       perl-Task-Catalyst 
Version:    4.02
Release:    alt1_28
# lib/Task/Catalyst.pm -> GPL+ or Artistic
License:    GPL+ or Artistic 

Summary:    All you need to start with Catalyst 
Source0:    https://cpan.metacpan.org/authors/id/B/BO/BOBTFISH/Task-Catalyst-%{version}.tar.gz
URL:        https://metacpan.org/release/Task-Catalyst
BuildArch:  noarch

BuildRequires: rpm-build-perl
BuildRequires: perl(ExtUtils/MakeMaker.pm)
# tests for Task::Catalyst itself
BuildRequires: perl(Test/More.pm)
# tests for release-testing
BuildRequires: perl(Pod/Coverage/TrustPod.pm)
BuildRequires: perl(Test/Pod.pm)
BuildRequires: perl(Test/Pod/Coverage.pm)

# This macro allows us to easily define identical Requires and BR
%global req_both() %{expand:\
Requires: %*\
BuildRequires: %*\
} 

# Core Modules
%req_both perl(Catalyst.pm) >= 5.800
%req_both perl(Catalyst/Devel.pm)
%req_both perl(Catalyst/Manual.pm)
# Recommended Models
%req_both perl(Catalyst/Model/Adaptor.pm)
%req_both perl(Catalyst/Model/DBIC/Schema.pm)
# Recommended Views
%req_both perl(Catalyst/View/TT.pm)
%req_both perl(Catalyst/View/Email.pm)
# Recommended Components
%req_both perl(Catalyst/Controller/ActionRole.pm)
%req_both perl(CatalystX/Component/Traits.pm)
%req_both perl(CatalystX/SimpleLogin.pm)
%req_both perl(Catalyst/Action/REST.pm)
%req_both perl(Catalyst/Component/InstancePerContext.pm)
# Session Support
%req_both perl(Catalyst/Plugin/Session.pm)
%req_both perl(Catalyst/Plugin/Session/State/Cookie.pm)
%req_both perl(Catalyst/Plugin/Session/Store/File.pm)
%req_both perl(Catalyst/Plugin/Session/Store/DBIC.pm)
# Authentication and Authorization
%req_both perl(Catalyst/Plugin/Authentication.pm)
%req_both perl(Catalyst/Authentication/Store/DBIx/Class.pm)
%req_both perl(Catalyst/Authentication/Credential/HTTP.pm)
%req_both perl(Catalyst/ActionRole/ACL.pm)
# Recommended Plugins
%req_both perl(Catalyst/Plugin/Static/Simple.pm)
%req_both perl(Catalyst/Plugin/Unicode/Encoding.pm)
%req_both perl(Catalyst/Plugin/I18N.pm)
%req_both perl(Catalyst/Plugin/ConfigLoader.pm)
# Testing, Debugging and Profiling
%req_both perl(Test/WWW/Mechanize/Catalyst.pm)
%req_both perl(Catalyst/Plugin/StackTrace.pm)
%req_both perl(CatalystX/REPL.pm)
%req_both perl(CatalystX/LeakChecker.pm)
%req_both perl(CatalystX/Profile.pm)
# Deployment
%req_both perl(FCGI.pm)
%req_both perl(FCGI/ProcManager.pm)
%req_both perl(Starman.pm)
%req_both perl(local/lib.pm)

# Make sure we pull it in, regardless of where it is
Requires:   %{_bindir}/catalyst.pl
Source44: import.info

%description
This package ensures everything you need to write serious Catalyst
applications is installed.  Install this if you're interested in 
developing Catalyst apps. 

%prep
%setup -q -n Task-Catalyst-%{version}

%build
PERL_AUTOINSTALL='--skipdeps' /usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
RELEASE_TESTING=1 TEST_POD=1 make test

%files
%doc Changes README 
%{perl_vendor_privlib}/Task*

%changelog
