# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Tee
%define upstream_version 0.14

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_11

Summary:    Pure Perl emulation of GNU tee
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module//%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Exporter.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Basename.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(Getopt/Long.pm)
BuildRequires: perl(IO/CaptureOutput.pm)
BuildRequires: perl(IO/File.pm)
BuildRequires: perl(Probe/Perl.pm)
BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Source44: import.info

%description
The 'Tee' distribution provides the the ptee manpage program, a pure Perl
emulation of the standard GNU tool 'tee'. It is designed to be a
platform-independent replacement for operating systems without a native
'tee' program. As with 'tee', it passes input received on STDIN through to
STDOUT while also writing a copy of the input to one or more files. By
default, files will be overwritten.

Unlike 'tee', 'ptee' does not support ignoring interrupts, as signal
handling is not sufficiently portable.

The 'Tee' module provides a convenience function that may be used in place
of 'system()' to redirect commands through 'ptee'.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

# Try to fix failure on BS
make

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml README
%perl_vendor_privlib/*
/usr/bin/ptee
/usr/share/man/man1/ptee.1.*

%changelog
