# BEGIN SourceDeps(oneline):
BuildRequires: perl(Minion/Job.pm) perl(Mojo/Base.pm) perl(Mojo/Collection.pm) perl(Mojo/File.pm) perl(Mojo/JSON.pm) perl(Mojo/Loader.pm) perl(Mojo/Pg.pm) perl(Mojo/UserAgent.pm) perl(Mojo/Util.pm) perl(Mojolicious/Commands.pm) perl(Test/Mojo.pm)
# END SourceDeps(oneline)
%define module_name Telebot
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Mojolicious-based Telegram bot
Group: Development/Perl
License: see LICENSE
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LI/LIOL/%{module_name}-%{version}.tgz
BuildArch: noarch

%description
This library helps to create mojolicious based Telegram
bots. Application works via telegram webhooks.
It creates route and register it in telegram. Requests
form telegram are processed on this route. Application
processes requests via minion tasks to minimize web
interaction time.
You can include your application logic in so called
handlers. You have several types of handlers - one
for update and one for each possible part of update.
Handlers are located in lib/Handler folder and have
corresponding names:

    Update.pm
    
    CallbackQuery.pm
    ChannelPost.pm
    ChatJoinRequest.pm
    ChatMember.pm
    ChosenInlineResult.pm
    EditedChannelPost.pm
    EditedMessage.pm
    InlineQuery.pm
    Message.pm
    MyChatMember.pm
    Poll.pm
    PollAnswer.pm
    PreCheckoutQuery.pm
    ShippingQuery.pm

To implement your logic you must overwrite subroutine
run

    package My::Bot::Handler::Message;
    use Mojo::Base 'Telebot::Handler', -signatures;

    sub run ($self) {
        
        # Your magic here
        
        $self;
    }

    1;

Handler have attributes
app - reference to application,
payload - data recieved from update,
update_id - Telegram ID of update.

Handler Update gets full update paypload.
Typed handlers gets only corresponding part of update.

For example if incoming update contain message -
two handlers will be executed - Update and Message.
Update will recieve full update payload, Message only
message part of update.

For interaction with Telegram API you can use helper
tg:request

    $self->app->tg->request(getMe => {});
    
    $self->app->tg->request(sendLocation => {
        chat_id => 777,
        latitude => 90-rand(180),
        longitude => 180-rand(360),
    });

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name
    

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/T*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
