# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Temperature-Calculate-DegreeDays
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.50
Release: alt1
Summary: Perl package to compute cooling, heating, and growing degree days
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AA/AALLGOOD/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A degree day is a measure of sensible temperature compared to a baseline 
temperature, typically integrated over time. Degree days have numerous 
applications in agriculture, as temperatures during the growing season have a 
direct impact on crop growth progress. Degree days also support energy usage 
monitoring, as the costs to heat and cool climate controlled structures is 
directly related to outdoor temperatures. The simplest method to calculate degree 
days is to compare the daily mean temperature (the average of the daily high and low 
observed temperatures) to a baseline temperature. This is how degree days are 
defined by the United States National Weather Service.

The Temperature::Calculate::DegreeDays package provides methods to calculate 
the following types of degree days:

=over 4

=item * Cooling degree days - zero if the baseline temperature exceeds the mean, otherwise the difference between the mean and baseline rounded to the nearest integer

=item * Heating degree days - zero if the mean temperature exceeds the baseline, otherwise the difference between the baseline and mean rounded to the nearest integer

=item * Growing degree days - same as cooling degree days, but when calculating the daily mean, temperatures exceeding a maximum "ceiling" value are set to the ceiling value

=back

This package was designed using an object-oriented framework, with a constructor 
method (new) that returns a blessed reference. The object stores the baseline 
temperature for heating and cooling degree days, a separate baseline temperature 
for growing degree days, a growing degree days ceiling temperature, and a value to 
be interpreted as missing data. The various degree days methods are designed to 
handle missing or invalid input data gracefully by returning the missing data value, 
but will fail if the caller does not supply the required number of arguments.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.pod ignore.txt Changes LICENSE
%perl_vendor_privlib/T*

%changelog
