%define module_name Template-Nest
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: manipulate a generic template structure via a perl hash
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOMGRACEY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is the HTML::Template::Nest manpage, but the dependency on `HTML::Template' is dropped, and the module is made generic (ie not specific to `HTML') for the following reasons:

=over

=item 1

Given the HTML::Template::Nest manpage only uses the `TMPL_VAR' parameter from the HTML::Template manpage, hauling around the rest of the HTML::Template manpage is unnecessary baggage

=item 2

There's no reason to restrict this to `HTML' either in name or function - this is a system of combining templates, which can be of any arbitrary format

=back


Let me take a moment to explain why I think the Template::Nest manpage is the *only* templating system that makes any sense.

The description for the Text::Template manpage says the following in the `Philosophy' section:

"When people make a template module like this one, they almost always start by inventing a special syntax for substitutions. For example, they build it so that a string like %%%%VAR%%%% is replaced with the value of $VAR. Then they realize the need extra formatting, so they put in some special syntax for formatting. Then they need a loop, so they invent a loop syntax. Pretty soon they have a new little template language.

This approach has two problems: First, their little language is crippled. If you need to do something the author hasn't thought of, you lose. Second: Who wants to learn another language? You already know Perl, so why not use it?"

These paragraphs agree with the philosophy of the Template::Nest manpage, in that you shouldn't need to invent a new language to fill in templates. However, the the Text::Template manpage description continues:

"Text::Template templates are programmed in Perl. You embed Perl code in your template, with { at the beginning and } at the end."

At this point the philosophy behind the Text::Template manpage and the Template::Nest manpage part ways. In the the Template::Nest manpage philosophy *templates are not "programmed" at all*. There should never be any code "embedded" in any template. Furthermore *it is n...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
