%define module_name Template-Plugin-Latex
Epoch: 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(FindBin.pm) perl(LaTeX/Driver.pm) perl(LaTeX/Encode.pm) perl(LaTeX/Table.pm) perl(Template.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 3.12
Release: alt1
Summary: Latex support for the Template Toolkit
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/EH/EHUELS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The `Latex' Template Toolkit plugin provides a `latex' filter that
allows the use of LaTeX to generate PDF, PostScript and DVI output files
from the Template Toolkit.  The plugin uses the LaTeX::Driver manpage to run the
various LaTeX programs.

Processing of the LaTeX document takes place in a temporary directory
that is deleted once processing is complete.  The standard LaTeX
programs (`latex' or `pdflatex', `bibtex' and `makeindex') are run
and re-run as necessary until all references, indexes, bibliographies,
table of contents, and lists of figures and tables are stable or it is
apparent that they will not stabilize.  The format converters `dvips',
`dvipdf', `ps2pdf' and `pdf2ps' are run as necessary to convert the
output document to the requested format.  The `TEXINPUTS' environment
variable is set up to include the template directory and the `INCLUDES'
directories, so that LaTeX file inclusion commands should find the
intended files.

The output of the filter is binary data (although PDF and PostScript are
not stictly binary).  You should be careful not to prepend or append any
extraneous characters (even space characters) or text outside the FILTER
block as this text will be included in the file output.  Notice in the
example below how we use the post-chomp flags ('-') at the end of the
`USE' and `END' directives to remove the trailing newline characters:

    [%% USE Latex(format='pdf') -%%]
    [%% FILTER latex %%]
    ...LaTeX document...
    [%% END -%%]

If you're redirecting the output to a file via the third argument of
the Template module's `process()' method then you should also pass
the `binmode' parameter, set to a true value to indicate that it is a
binary file.

    use Template;

    my $tt = Template->new({
        INCLUDE_PATH => '/path/to/templates',
        OUTPUT_PATH  => '/path/to/pdf/output',
    });
    my $vars = {
        title => 'Hello World',
    }
    $tt->process('example.tt2', $vars, 'example.pdf', binmode => 1)
        || die $tt->error();

If you want to capture the output to a template variable, you can do
so like this:

    [%% output = FILTER latex %%]
    ...LaTeX document...
    [%% END %%]

You can pass additional arguments when you invoke the filter, for
example to specify the output format.

    [%% FILTER latex(format='pdf') -%%]
       ...LaTeX document...
    [%% END %%]

If you want to write the output to a file then you can specify an
`output' parameter.

    [%% FILTER latex(output='example.pdf') %%]
    ...LaTeX document...
    [%% END %%]

If you don't explicity specify an output format then the filename
extension (e.g. 'pdf' in the above example) will be used to determine
the correct format.

You can specify a different filter name using the `filter' parameter.

    [%% USE Latex(filter='pdf') -%%]
    [%% FILTER pdf %%]
    ...LaTeX document...
    [%% END %%]

You can also specify the default output format.  This value can be
`latex', `pdf' or `dvi'.

    [%% USE Latex(format='pdf') %%]


Note: the `LaTeX::Driver' distribution includes three filter programs
(`latex2dvi', `latex2pdf' and `latex2ps') that use the
`LaTeX::Driver' package to process LaTeX source data into DVI, PDF or
PostScript file respectively.  These programs have a `-tt2' option to
run their input through the Template Toolkit before processing as LaTeX
source.  The programs do not use the `Latex' plugin unless the template
requests it, but they may provide an alternative way of processing
Template Toolkit templates to generate typeset output.



%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README TODO Changes
%perl_vendor_privlib/T*

%changelog
