%define module_name Template-Plugin-Next
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Cwd.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Template/Exception.pm) perl(Template/Plugin.pm) perl(Template/Test.pm) perl(Test/CPAN/Meta.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(base.pm) perl(blib.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: include the 'next' template file with identical relative path
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AL/ALEXK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a plugin for the Template Toolkit distribution that allows the inclusion of template files with identical relative paths like the present template. Those templates are 'hidden' by the present template, because their respective INCLUDE_PATH entries are dominated by the one of the including template.

The functionality provided by this plugin might come handy in multi skin situations where default templates are selectively redefined by a skin using a dominating INCLUDE_PATH entry for the skin and identical relative paths to the templates as with the default templates - thus hiding them. 

The Next-plugin allows to include the dominated default templates from inside the hiding template in order to decorate the default template or include a parameterized version of it. 

Example:

  # We assume: INCLUDE_PATH='/templates/c:/templates/b:/templates/a'

  # template a/test.tt (note this template accepts a "parameter" called 'repeat'):
  [%% repeat = repeat || 1; 'a' | repeat(repeat) %%]
  
  # template b/test.tt:
  b
  [%% USE Next; Next.include( repeat => 3 ); %%]
  b
  
  # template c/test.tt:
  c
  [%% USE Next; Next.include(); %%]
  c

  # a call to template test.tt
  [%% INCLUDE test.tt %%]
  
  # would yield something like the following (with POST_CHOMP set to 1):
  
  c
  b
  aaa
  b
  c



%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/T*

%changelog
