%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(Filter/Util/Call.pm) perl(LWP/Simple.pm) perl(MIME/Base64.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Template.pm) perl(Template/Plugin.pm) perl(Text/Diff.pm) perl(YAML.pm) perl(base.pm) perl(inc/Module/Install.pm) perl(overload.pm) perl(threads/shared.pm)
# END SourceDeps(oneline)
%define module_version 0.06
%define module_name Template-Plugin-Perl
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: TT2 plugin to import Perl built-in functions
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AG/AGENT/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
As a TT programmer, I found it quite inflexible to use the Template Toolkit's
presentation language Language due to the very limited vocabulary. So I wrote 
this little plugin in order to open a window for the template file to the full
richness of most Perl built-in functions, making the Template language a 
"programming language" in a much more serious sense.

As I writing this stuff, The Template language does not support exponential
operator (**). So I add an extra function 'pow' to support this missing
feature. However, there is no doubt that we could treat "Perl.eval" as a
good workaround, just as the the SYNOPSIS entry elsewhere in this document demonstrates.

According to the current implementation, don't use the functions for real 
@ARRAYs, such as shift, pop. They won't function at all. However,
`sort', `join', and `reverse' are notable exceptions. Moreover, 
Arguments of all Perl.* functions are passed by values, and returned in 
scalar context, so some functions for list data, like map and grep, 
make little sense in this context.

builtins that modify their arguments won't work either, such as `chomp', `chop', and `pos'.

Please keep in mind I just used AUTOLOAD, eval, and Data::Dumper to do the
magic here.

If you're looking for even more functions, I suggest you take a look at the
the Template::Plugin::POSIX manpage module which exports the excellent POSIX repertoire.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
