# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Build/Tiny.pm) perl(String/CRC32.pm) perl(Template/Plugin.pm) perl(Template/Stash.pm) perl(Template/Test.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_name Template-Plugin-String-CRC32
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: L<Template::Toolkit> plugin-wrapper of L<String::CRC32>
Group: Development/Perl
License: perl
URL: https://github.com/gnatyna/Template-Plugin-String-CRC32

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GN/GNATYNA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
*Template::Plugin::String::CRC32* is wrapper of the String::CRC32 manpage module for the Template::Toolkit manpage.
It provides access to CRC32 algorithm via the `String::CRC32' module.
It is used like a plugin but installs filter and vmethod into the current context.

When you invoke
 
  [%% USE String::CRC32 %%]

the following filter (and vmethod of the same name) is installed
into the current context:

=over 4

=item `crc32'

Calculate the CRC 32bit checksum of the input, and return it as 4-bytes integer.

=back

As the filter is also available as vmethod the following are all
equivalent:

    FILTER crc32; content; END;
    content FILTER crc32;
    content.crc32;



%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/T*

%changelog
