%define module_name Template-Tiny-Strict
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.18
Release: alt1
Summary: Template Toolkit reimplemented in as little code as possible
Group: Development/Perl
License: perl
URL: https://metacpan.org/pod/Template::Tiny::Strict

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/O/OV/OVID/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Template::Tiny::Strict is a drop-in replacement for the Template::Tiny manpage. By default,
the behavior is identical. However, we have new *optional* arguments you can pass
to the constructor:

=over 4

=item * `forbid_undef'

If true, *any* access of an undefined value in the template will cause the code to `croak'
with an error such as:

    Undefined value in template path 'items.1'

=item * `forbid_unused'

If true, *any* variable passed in the stash that is not used will cause the coad to
`croak' with an error such as:

    The following variables were passed to the template but unused: 'name'

=item * `name'

Accepts a string as the "name" of the template. Errors will be reported with
this name. Make it easier to track down the errant template if you are
generating plenty of them.

=back

All errors are gathered and reported at once.

Note: what follows is the remainder of the original POD.

It is intended for use in light-usage, low-memory, or low-cpu templating
situations, where you may need to upgrade to the full feature set in the
future, or if you want the retain the familiarity of TT-style templates.

For the subset of functionality it implements, it has fully-compatible template
and stash API. All templates used with Template::Tiny::Strict should be able to be
transparently upgraded to full Template Toolkit.

Unlike Template Toolkit, Template::Tiny::Strict will process templates without a
compile phase (but despite this is still quicker, owing to heavy use of
the Perl regular expression engine.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTING Changes LICENSE README
%perl_vendor_privlib/T*

%changelog
