# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm)
# END SourceDeps(oneline)
%define module_version 2.0
%define module_name TemplateRex
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.0
Release: alt1
Summary: A Template toolkit that partitions code from text and uses nestable sections.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TR/TROXEL/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
The objective of TemplateRex is to achieve complete separation between
code and presentation. While this module was developed with html generation
in mind it works equally well with any text based files (such as gnuplot scripts).

Most CGI web based application start off with placing all the html text within print
statements in the code or generate html via functions such as with CGI.pm.  For applications
of any size or sophistication this approach quickly develops maintenance issues such as

=over 2

=item *
Code becomes bloated with embedded html.

=item *
Cannot leaverage the use of wysiwyg html generators (Dreamweaver, Frontpage).

=item *
The html is within the domain of the code programmer and not the html designers.

=back

Templates solve this problem by outsourcing the presentation or html outside the code.
The next step of evolution is then to place code within the html (asp, php, jsp) to handle
things like generating rows of a table or repeated sections or chunks of html.  The problem
with appoach are

=over 2

=item *
HTML becomes bloated with embedded code

=item * If you are using several 'skins' or templates sets for a different look-and-feel
for an application, pieces of code tend to be replicated in different templates sets.

=item * Cannot leaverage the use of wysiwyg html generators (Dreamweaver, Frontpage).

=item * Security issues with templates being able to execute code.  That is you need
to be able to 'trust' your template designers.

=back

It is the opinion of the author that both extremes present their own sets of problems and
that partitioning of code from presentation into their own separate realms is the best approach
for long term maintenance of large and/or sophisticated web applications.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/T*

%changelog
