# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(App/RewriteVersion.pm) perl(autodie.pm) perl(complete.pl) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name		Term-Clui
%define upstream_version 1.76

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_3

Summary:    %{upstream_name} module for perl
License:    GPLv2+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}/
Source0:    https://cpan.metacpan.org/modules/by-module/Term/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Copy.pm)
BuildRequires: perl(Term/ReadLine.pm)
BuildArch:  noarch
Source44: import.info

%description
Term::Clui offers a high-level user interface to give the user of
command-line applications a consistent "look and feel". Its metaphor
for the computer is as a human-like conversation-partner, and as each
question/response is completed it is summarised onto one line, and
remains on screen, so that the history of the session gradually
accumulates on the screen and is available for review, or for
cut/paste. This user interface can therefore be intermixed with
standard applications which write to STDOUT or STDERR, such as
make, pgp, rcs etc.

For the user, &choose uses arrow keys (or hjkl) and Return or q;
also SpaceBar for multiple choices. &confirm expects y, Y, n or N.
In general, ctrl-L redraws the (currently active bit of the) screen.
&edit and &view use the default EDITOR and PAGER if possible.

It's fast, simple, and has few external dependencies. It doesn't use curses
(which is a whole-of-screen interface); it uses a small subset of vt100
sequences (up down left right normal and reverse) which are very portable.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
make

%check
%{__make} test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README examples
%{perl_vendor_privlib}/Term

%changelog
