# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Term-ReadLine-Zoid
%define upstream_version 0.07

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_10

Summary:    A readline file browser mode
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Term/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(AutoLoader.pm)
BuildRequires: perl(AutoSplit.pm)
BuildRequires: perl(Term/ReadKey.pm)
BuildRequires: perl(Module/Build/Compat.pm)
BuildArch: noarch
Source44: import.info

%description
This package provides a set of modules that form an interactive input
buffer written in plain perl with minimal dependencies. It features almost
all key-bindings described in the posix spec for the sh(1) utility with
some extensions like multiline editing; this includes a vi-command mode
with a save-buffer (for copy-pasting) and an undo-stack.

Historically this code was part of the Zoidberg shell, but this
implementation is complete independent from zoid and uses the
Term::ReadLine interface, so it can be used with other perl
programs.

( The documentation sometimes refers to 'the application', this is the
program using the ReadLine module for input. )

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.yml README
%perl_vendor_privlib/*




%changelog
