# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(IO/Uncompress/Bunzip2.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.09
%define module_name Term-TtyRec-Plus
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: read a ttyrec
Group: Development/Perl
License: perl
URL: http://github.com/sartak/Term-TtyRec-Plus/tree

Source0: http://cpan.org.ua/authors/id/S/SA/SARTAK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
`Term::TtyRec::Plus' is a module that lets you read ttyrec files. The related module, Term::TtyRec is designed more for simple interactions. `Term::TtyRec::Plus' gives you more information and, using a callback, lets you munge the data block and timestamp. It will do all the subtle work of making sure timing is kept consistent, and of rebuilding each frame header.

    use Term::TtyRec::Plus;
    # complete (but simple) ttyrec playback script

    foreach my $file (@ARGV) {
      my $ttyrec = Term::TtyRec::Plus->new(infile => $file, time_threshold => 10);
      while (my $frame_ref = $ttyrec->next_frame()) {
        select undef, undef, undef, $frame_ref->{diff};
        print $frame_ref->{data};
      }
    }

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
