Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Test-Able
Version:        0.11
Release:        alt2_37
Summary:        xUnit with Moose
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Test-Able
Source0:        https://cpan.metacpan.org/authors/id/J/JD/JDV/Test-Able-%{version}.tar.gz
# Fix Moose enum warnings, CPAN RT#92396
Patch0:         Test-Able-0.11-Moose_enum.patch
# Adapt to Test-Simple-1.302019, bug #1338792, CPAN RT#65249
Patch1:         Test-Able-0.11-Adapt-to-Test-Simple-1.302019.patch
BuildArch:      noarch
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(Module/Install/AuthorTests.pm)
BuildRequires:  perl(Module/Install/Metadata.pm)
BuildRequires:  perl(Module/Install/WriteAll.pm)
BuildRequires:  perl(List/Util.pm)
BuildRequires:  perl(Moose.pm)
BuildRequires:  perl(Moose/Exporter.pm)
BuildRequires:  perl(Moose/Role.pm)
BuildRequires:  perl(Moose/Util/MetaRole.pm)
BuildRequires:  perl(Moose/Util/TypeConstraints.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Sub/Exporter.pm)
BuildRequires:  perl(Test/Builder.pm)
# Tests only:
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Test/More.pm)
Requires:       perl(Moose.pm) >= 0.940

# Do not export underspecified dependencies

Source44: import.info
%filter_from_requires /^perl(Moose\\)\\s*$/d

%description
An xUnit style testing framework inspired by Test::Class and built using
Moose. It can do all the important things Test::Class can do and more. The
prime advantages of using this module instead of Test::Class are
flexibility and power. Namely, Moose.

%prep
%setup -q -n Test-Able-%{version}
%patch0 -p1
%patch1 -p1

# Remove bundled libraries
rm -r inc
sed -i -e '/^inc\// d' MANIFEST

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -delete
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc Changes README TODO
%{perl_vendor_privlib}/*

%changelog
