Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Test/Differences.pm) perl(Test/Unit/TestCase.pm) perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
 # Run release test
%if ! (0%{?rhel} && 0%{?rhel} < 8)
%bcond_without perl_Test_Assert_enables_release_test
%else
%bcond_with perl_Test_Assert_enables_release_test
%endif

# noarch, but to avoid *.list files interfering with signature test
%global debug_package %{nil}

# Store keys in a temp directory
%global gnupghome %(mktemp --directory)

Name:		perl-Test-Assert
Version:	0.0504
Release:	alt2_42
Summary:	Assertion methods for those who like JUnit
License:	GPL-1.0-or-later OR Artistic-1.0-Perl
URL:		https://metacpan.org/release/Test-Assert
Source0:	https://cpan.metacpan.org/modules/by-module/Test/Test-Assert-%{version}.tar.gz
# Upstream signing key, bug #1118362
Source1:	C0B10A5B.pub
Patch0:		Test-Assert-0.0504-Critic.patch
BuildArch:	noarch
# Module Build
BuildRequires:	coreutils
BuildRequires:	findutils
BuildRequires:	gnupg2
BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel
BuildRequires:	perl(Module/Build.pm)
# Module Runtime
BuildRequires:	perl(constant.pm)
BuildRequires:	perl(constant/boolean.pm)
BuildRequires:	perl(Exception/Base.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(Symbol/Util.pm)
BuildRequires:	perl(warnings.pm)
# Test Suite
BuildRequires:	perl(Carp.pm)
BuildRequires:	perl(Class/Inspector.pm)
BuildRequires:	perl(Cwd.pm)
BuildRequires:	perl(File/Basename.pm)
BuildRequires:	perl(File/Spec.pm)
BuildRequires:	perl(parent.pm)
BuildRequires:	perl(Test/Builder.pm)
BuildRequires:	perl(Test/More.pm)
BuildRequires:	perl(Test/Unit/Lite.pm)
# Release Tests
%if %{with perl_Test_Assert_enables_release_test}
BuildRequires:	patch
BuildRequires:	perl(File/Find.pm)
BuildRequires:	perl(File/Slurp.pm)
BuildRequires:	perl(Test/CheckChanges.pm)
BuildRequires:	perl(Test/Distribution.pm)
BuildRequires:	perl(Test/Kwalitee.pm)
BuildRequires:	perl(Test/MinimumVersion.pm)
BuildRequires:	perl(Test/Perl/Critic.pm)
BuildRequires:	perl(Test/Pod.pm)
BuildRequires:	perl(Test/Pod/Coverage.pm)
BuildRequires:	perl(Test/Signature.pm)
BuildRequires:	perl(Test/Spelling.pm), hunspell-en
%endif
Source44: import.info
# Dependencies
# (none)

%description
This class provides a set of assertion methods useful for writing tests.
The API is based on JUnit4 and Test::Unit and the methods die on failure.

%prep
%setup -q -n Test-Assert-%{version}

# Drop exec bits and avoid doc-file dependencies
chmod -c -x eg/*

# Import upstream's GPG key so we don't need to fetch it from a keyserver
# when running the signature test
export GNUPGHOME=%{gnupghome}
gpg2 --import %{SOURCE1}

%build
perl Build.PL --installdirs=vendor
./Build

%install
./Build install --destdir=%{buildroot} --create_packlist=0
# %{_fixperms} -c %{buildroot}

%check
# === MAIN TEST SUITE === #

./Build test

# ===  RELEASE TESTS  === #
%if %{with perl_Test_Assert_enables_release_test}

export GNUPGHOME=%{gnupghome}
RELEASE_TESTS="$(echo xt/*.t)"

# Don't run the copyright test as it will fail after the year of module release
RELEASE_TESTS="$(echo $RELEASE_TESTS | sed 's|xt/copyright.t||')"

# Don't run the spelling test yet as we need to add extra stopwords
RELEASE_TESTS="$(echo $RELEASE_TESTS | sed 's|xt/pod_spell.t||')"

# Don't run the perlcritic test yet as we need to patch the code
RELEASE_TESTS="$(echo $RELEASE_TESTS | sed 's|xt/perlcritic.t||')"

# Signature test would fail on recent distros due to presence of MYMETA.*
[ -f MYMETA.yml ] && mv MYMETA.yml ..
[ -f MYMETA.json ] && mv MYMETA.json ..

RELEASE_TESTING=1 ./Build test --test_files "$RELEASE_TESTS"

# Put any MYMETA.* files back where they were
[ -f ../MYMETA.yml ] && mv ../MYMETA.yml .
[ -f ../MYMETA.json ] && mv ../MYMETA.json .

# Patch the code to tidy it and turn off one check before running the perlcritic test
patch -p0 < %{P:0}
./Build test --test_files xt/perlcritic.t
patch -p0 -R < %{P:0}

# Fix the POD Spell test and run it
mv xt/pod_spellrc xt/pod_spellrc.orig
(
	cat xt/pod_spellrc.orig
	echo "'fail'"
	echo "JUnit4"
	echo "value1"
	echo "value2"
) > xt/pod_spellrc
./Build test --test_files xt/pod_spell.t
mv xt/pod_spellrc.orig xt/pod_spellrc

%endif

%files
%doc --no-dereference LICENSE
%doc Changes README eg/
%{perl_vendor_privlib}/Exception/
%{perl_vendor_privlib}/Test/

%changelog
