# BEGIN SourceDeps(oneline):
BuildRequires: perl(Benchmark.pm) perl(Config.pm) perl(Error.pm) perl(Error/Simple.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(HTTP/Response.pm) perl(IO/File.pm) perl(LWP/UserAgent.pm) perl(Pod/Simple/HTML.pm) perl(Test/More.pm) perl(Test/Unit/Debug.pm) perl(Test/Unit/HarnessUnit.pm) perl(Test/Unit/TestCase.pm) perl(Test/Unit/TestRunner.pm) perl(Test/Unit/TestSuite.pm) perl(URI.pm) perl(base.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.08
%define module_name Test-C2FIT
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: A direct Perl port of Ward Cunningham's FIT acceptance test framework for Java
Group: Development/Perl
License: perl
URL: http://fit.c2.com

Source0: http://cpan.org.ua/authors/id/T/TJ/TJBYRNE/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Great software requires collaboration and communication. Fit is a tool for.enhancing collaboration in software development. It's an invaluable way
to collaborate on complicated problems - and get them right - early
in development.

Fit allows customers, testers, and programmers to learn what their 
software should do and what it does do. It automatically compares
customers' expectations to actual results.

This port of FIT has a featureset equivalent to v1.1 of FIT.  
Dave W. Smith's original port was based on fit-b021021j and I've updated 
most of the core to match the 1.1 version.

This port passes the current FIT spec and also implements a all of the
examples.


The following functions are provided (and exported) by this module:

=over 4

=item file_runner($infile,$outfile)

Process a FIT-document contained in $infile and writes the result to $outfile.

=item wiki_runer($infile,$outfile)

Same as file_runner, except that not <table>, <tr> and <td>
but <wiki>, <table>, <tr> and <td> is searched for in the input
document.

=item fit_shell

Creates an interactive shell from which you can easily run tests. Start it
and enter "help" for more information.

Suppose, your tests-related files reside in a directory with three subdirectories:
input - where the files come from, output - where the results will be written to and
lib - where your fixtures reside, all you need to do is just to enter "runall"

=back

%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc ReleaseNotes README Changes examples
%perl_vendor_privlib/T*

%changelog
