Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Perform optional tests
%if 0%{?rhel} >= 10
%bcond_with perl_Test_CheckChanges_enables_optional_test
%else
%bcond_without perl_Test_CheckChanges_enables_optional_test
%endif

Name:		perl-Test-CheckChanges
Summary:	Check that the Changes file matches the distribution
Version:	0.14
Release:	alt2_41
License:	GPL-1.0-or-later OR Artistic-1.0-Perl
URL:		https://metacpan.org/release/Test-CheckChanges
Source0:	https://cpan.metacpan.org/modules/by-module/Test/Test-CheckChanges-%{version}.tar.gz
BuildArch:	noarch
# Module Build
BuildRequires:	coreutils
BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel
BuildRequires:	perl(Module/Build.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(warnings.pm)
# Module Runtime
BuildRequires:	perl(Carp.pm)
BuildRequires:	perl(Cwd.pm)
BuildRequires:	perl(File/Basename.pm)
BuildRequires:	perl(File/Glob.pm)
BuildRequires:	perl(File/Spec.pm)
BuildRequires:	perl(Module/Build/Version.pm)
BuildRequires:	perl(Test/Builder.pm)
# Test Suite
BuildRequires:	perl(English.pm)
BuildRequires:	perl(Test/More.pm)
%if %{with perl_Test_CheckChanges_enables_optional_test}
# Optional Tests
BuildRequires:	perl(Perl/Critic/Policy/NamingConventions/Capitalization.pm)
BuildRequires:	perl(Perl/Critic/Policy/ValuesAndExpressions/ProhibitMagicNumbers.pm)
BuildRequires:	perl(Test/Exception.pm)
BuildRequires:	perl(Test/Perl/Critic.pm)
BuildRequires:	perl(Test/Pod.pm)
BuildRequires:	perl(Test/Pod/Coverage.pm)
%endif
# Dependencies
Requires:	perl(Module/Build/Version.pm)
Source44: import.info

%description
This module checks that your Changes file has an entry for the current version
of the Module being tested. The version information for the distribution being
tested is taken out of the Build data, or if that is not found, out of the
Makefile. It then attempts to open, in order, a file with the name Changes or
CHANGES. The Changes file is then parsed for version numbers. If one and only
one of the version numbers matches, the test passes; otherwise the test fails.
A message with the current version is printed if the test passes; otherwise
diagnostic messages are printed to help explain the failure.

%prep
%setup -q -n Test-CheckChanges-%{version}

%build
perl Build.PL --installdirs=vendor
./Build

%install
./Build install --destdir=%{buildroot} --create_packlist=0
# %{_fixperms} -c %{buildroot}

%check
%if %{with perl_Test_CheckChanges_enables_optional_test}
export TEST_AUTHOR=1
%endif
./Build test

%files
%doc Changes examples/ README
%{perl_vendor_privlib}/Test/

%changelog
